parcel_services.controllers.module('overview',
	['xhr', 'loading_spinner', `${gx.source}/libs/info_messages`,],
	() => {
		return {
			vue: true,
			name: 'gx-parcel-services-overview',
			template: '#parcel-services-overview',
			props: ['languages'],
			data: () => ({
				page: 1,
				offset: 0,
				limit: 10,
				totalItems: 0,
				totalPages: 1,
				sortOrder: 'asc',
				lang: {
					columns: {
						name: jse.core.lang.translate('label_name', 'parcel_services'),
						isDefault: jse.core.lang.translate('label_is_default', 'parcel_services'),
					},
					pagination: {
						limits: {
							10: jse.core.lang.translate('option_limits_10', 'parcel_services'),
							25: jse.core.lang.translate('option_limits_25', 'parcel_services'),
							50: jse.core.lang.translate('option_limits_50', 'parcel_services'),
							100: jse.core.lang.translate('option_limits_100', 'parcel_services'),
						},
						offset: {
							of: jse.core.lang.translate('label_offset_of', 'parcel_services'),
							to: jse.core.lang.translate('label_offset_to', 'parcel_services'),
						},
						page: {
							previous: jse.core.lang.translate('label_page_previous', 'parcel_services'),
							next: jse.core.lang.translate('label_page_next', 'parcel_services'),
						},
					},
					labels: {
						noParcelServicesExist: jse.core.lang.translate('label_no_data', 'parcel_services'),
						isDefault: jse.core.lang.translate('label_is_default', 'parcel_services'),
					},
					create: jse.core.lang.translate('create', 'buttons'),
				},
				parcelServices: [],
				deleteDetails: undefined,
				editDetails: undefined,
				parsedLanguages: [],
			}),
			methods: {
				loadTableData() {
					const vm = this;
					const $target = $('table.parcel-services');
					const spinner = jse.libs.loading_spinner.show($target);
					
					jse.libs.xhr.get({
						url: './api/parcel-services',
						data: {
							limit: this.limit,
							offset: this.offset,
							order: this.sortOrder,
						}
					}).done(response => {
						vm.parcelServices = response.parcelServices;
						vm.totalItems = response.totalItems;
						vm.totalPages = Math.ceil(vm.totalItems / vm.limit);
						jse.libs.loading_spinner.hide(spinner);
					}).fail((response) => {
						console.error('Could not load parcel services.', response);
						jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_load_parcel_services', 'parcel_services'));
						jse.libs.loading_spinner.hide(spinner);
						vm.parcelServices = [];
						vm.totalItems = 0;
						vm.totalPages = 1;
					});
				},
				showPreviousPage() {
					this.page = this.page === 1 ? 1 : this.page - 1;
					this.updateOffset();
				},
				showNextPage() {
					this.page = this.page === this.totalPages ? this.totalPages : this.page + 1;
					this.updateOffset();
				},
				updatedLimit() {
					this.page = 1;
					this.offset = (this.page - 1) * this.limit;
					this.loadTableData();
				},
				updateOffset() {
					this.offset = (this.page - 1) * this.limit;
					this.loadTableData();
				},
				changeSorting() {
					this.sortOrder = (this.sortOrder === 'desc') ? 'asc' : 'desc';
					this.loadTableData();
				},
				openCreateModal() {
					this.$children[0].openModal();
				},
				openEditModal(editDetails) {
					this.$children[1].openModal(editDetails);
				},
				openDeleteModal(deleteDetails) {
					this.$children[2].openModal(deleteDetails);
				},
			},
			mounted() {
				this.parsedLanguages = JSON.parse(this.languages);
				this.loadTableData();
			},
			init: done => done()
		}
	});